VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "Msflxgrd.ocx"
Begin VB.Form Acquire 
   Caption         =   "Stimulus / Response Application for DriverLINX"
   ClientHeight    =   9285
   ClientLeft      =   540
   ClientTop       =   2040
   ClientWidth     =   11820
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   9285
   ScaleWidth      =   11820
   Begin VB.CheckBox chkUpdateExcelOnEnd 
      Caption         =   "Auto-Update when task ends"
      Height          =   255
      Left            =   1800
      TabIndex        =   21
      Top             =   7440
      Width           =   2655
   End
   Begin VB.CheckBox chkResetFreq 
      Caption         =   "Reset frequency response data"
      Height          =   255
      Left            =   1800
      TabIndex        =   26
      Top             =   8640
      Width           =   2895
   End
   Begin VB.CheckBox chkSaveFreq 
      Caption         =   "Save frequency response data"
      Height          =   255
      Left            =   1800
      TabIndex        =   25
      Top             =   8400
      Value           =   1  'Checked
      Width           =   2775
   End
   Begin VB.CheckBox chkHanning 
      Caption         =   "Apply Hanning window to data"
      Height          =   255
      Left            =   1800
      TabIndex        =   24
      Top             =   8160
      Value           =   1  'Checked
      Width           =   2775
   End
   Begin VB.TextBox ActualFrequencyTextBox 
      Enabled         =   0   'False
      Height          =   285
      Left            =   10200
      TabIndex        =   40
      TabStop         =   0   'False
      Top             =   1560
      Width           =   1455
   End
   Begin VB.CheckBox chkMakeExcelVisible 
      Caption         =   "Make Excel visible"
      Height          =   255
      Left            =   1800
      TabIndex        =   23
      Top             =   7920
      Value           =   1  'Checked
      Width           =   2055
   End
   Begin VB.CheckBox chkSaveAfterUpdate 
      Caption         =   "Autosave after update"
      Height          =   255
      Left            =   1800
      TabIndex        =   22
      Top             =   7680
      Width           =   2055
   End
   Begin VB.CheckBox chkSaveContinuous 
      Caption         =   "Save combined text data continuously Caution: Use only with low Sampling Freq."
      Enabled         =   0   'False
      Height          =   375
      Left            =   8520
      TabIndex        =   20
      Top             =   7920
      Width           =   3255
   End
   Begin VB.Frame Frame3 
      Caption         =   "AO/AI Text Data File"
      Height          =   855
      Left            =   9840
      TabIndex        =   48
      Top             =   6480
      Width           =   1815
      Begin VB.OptionButton OptAppendBoth 
         Caption         =   "Append data"
         Height          =   195
         Left            =   120
         TabIndex        =   33
         Top             =   480
         Width           =   1455
      End
      Begin VB.OptionButton optOverwriteBoth 
         Caption         =   "Overwrite data"
         Height          =   195
         Left            =   120
         TabIndex        =   17
         Top             =   240
         Width           =   1575
      End
   End
   Begin VB.TextBox FileBoxBoth 
      Height          =   285
      Left            =   8520
      TabIndex        =   16
      Text            =   "c:\aiao.txt"
      Top             =   6480
      Width           =   1215
   End
   Begin VB.CommandButton cmdSaveBoth 
      Caption         =   "Save Current set of Both Data to Text File"
      Height          =   495
      Left            =   8520
      TabIndex        =   15
      Top             =   5880
      Width           =   3135
   End
   Begin VB.CommandButton cmdSaveIn 
      Caption         =   "Save Current Set of AI Data to Text File"
      Height          =   495
      Left            =   8520
      TabIndex        =   12
      Top             =   4200
      Width           =   3135
   End
   Begin VB.CommandButton cmdSaveOut 
      Caption         =   "Save Current Set of AO Data to Text File"
      Height          =   495
      Left            =   8520
      TabIndex        =   8
      Top             =   2520
      Width           =   3135
   End
   Begin VB.CheckBox chkUpdateOnEnd 
      Caption         =   "Auto-Update when task ends"
      Height          =   255
      Left            =   8520
      TabIndex        =   18
      Top             =   7440
      Value           =   1  'Checked
      Width           =   2415
   End
   Begin VB.CommandButton cmdUpdateGridWindow 
      Caption         =   "Update Window"
      Height          =   495
      Left            =   5040
      TabIndex        =   30
      Top             =   7440
      Width           =   1575
   End
   Begin MSFlexGridLib.MSFlexGrid MSFlexGrid1 
      Height          =   7095
      Left            =   5040
      TabIndex        =   45
      TabStop         =   0   'False
      Top             =   240
      Width           =   3255
      _ExtentX        =   5741
      _ExtentY        =   12515
      _Version        =   393216
      Rows            =   1000
      Cols            =   3
      AllowUserResizing=   1
   End
   Begin VB.CheckBox chkContinuous 
      Caption         =   "Run Continuously"
      Height          =   255
      Left            =   8520
      TabIndex        =   19
      Top             =   7680
      Width           =   1695
   End
   Begin VB.CommandButton cmdUpdateExcelWindow 
      Caption         =   "Update Excel"
      Height          =   495
      Left            =   120
      TabIndex        =   29
      Top             =   7440
      Width           =   1575
   End
   Begin VB.TextBox FileBoxSaveAsExcel 
      Height          =   285
      Left            =   6720
      TabIndex        =   28
      Text            =   "c:\rawdata.xls"
      Top             =   8040
      Width           =   1575
   End
   Begin VB.TextBox FileBoxExcelLink 
      Height          =   285
      Left            =   120
      TabIndex        =   27
      Text            =   "c:\layout.xls"
      Top             =   8040
      Width           =   1575
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save as Excel Data"
      Height          =   495
      Left            =   6720
      TabIndex        =   31
      Top             =   7440
      Width           =   1575
   End
   Begin VB.TextBox CyclesTextBox 
      Height          =   285
      Left            =   8520
      TabIndex        =   7
      Text            =   "1"
      Top             =   1560
      Width           =   1455
   End
   Begin VB.TextBox SamplingFrequencyTextBox 
      Height          =   285
      Left            =   10200
      TabIndex        =   6
      Text            =   "50000"
      Top             =   960
      Width           =   1455
   End
   Begin VB.TextBox NumberOfSamplesTextBox 
      Height          =   285
      Left            =   8520
      TabIndex        =   5
      Text            =   "1000"
      Top             =   960
      Width           =   1455
   End
   Begin VB.TextBox OffsetTextBox 
      Height          =   285
      Left            =   10200
      TabIndex        =   4
      Text            =   "0"
      Top             =   360
      Width           =   1455
   End
   Begin VB.TextBox AmplitudeTextBox 
      Height          =   285
      Left            =   8520
      TabIndex        =   3
      Text            =   "1"
      Top             =   360
      Width           =   1455
   End
   Begin VB.Frame Frame1 
      Caption         =   "AO Text Data File"
      Height          =   855
      Left            =   9840
      TabIndex        =   34
      Top             =   3120
      Width           =   1815
      Begin VB.OptionButton optAppendOut 
         Caption         =   "Append data"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   480
         Width           =   1455
      End
      Begin VB.OptionButton optOverwriteOut 
         Caption         =   "Overwrite data"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   240
         Width           =   1575
      End
   End
   Begin VB.TextBox FileBoxOut 
      Height          =   285
      Left            =   8520
      TabIndex        =   9
      Text            =   "c:\ao.txt"
      Top             =   3120
      Width           =   1215
   End
   Begin VB.OptionButton optAppendIn 
      Caption         =   "Append data"
      Height          =   255
      Left            =   9960
      TabIndex        =   32
      Top             =   5280
      Width           =   1455
   End
   Begin VB.OptionButton optOverwriteIn 
      Caption         =   "Overwrite data"
      Height          =   255
      Left            =   9960
      TabIndex        =   14
      Top             =   5040
      Width           =   1455
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   495
      Left            =   5160
      TabIndex        =   1
      Top             =   8760
      Width           =   1215
   End
   Begin VB.TextBox FileBoxIn 
      Height          =   285
      Left            =   8520
      TabIndex        =   13
      Text            =   "c:\ai.txt"
      Top             =   4800
      Width           =   1215
   End
   Begin VB.CommandButton cmdExit 
      Cancel          =   -1  'True
      Caption         =   "Exit"
      Height          =   495
      Left            =   10440
      TabIndex        =   2
      Top             =   8760
      Width           =   1215
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Default         =   -1  'True
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   8760
      Width           =   1215
   End
   Begin DlsrLib.DriverLINXSR SR2 
      Left            =   8880
      Top             =   8760
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   8520
      Top             =   8760
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR1 
      Left            =   8160
      Top             =   8760
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Frame Frame2 
      Caption         =   "AI Text Data File"
      Height          =   855
      Left            =   9840
      TabIndex        =   35
      Top             =   4800
      Width           =   1815
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      Caption         =   "Frequency (Hz)"
      Height          =   255
      Left            =   10200
      TabIndex        =   49
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      Caption         =   "Excel OLE Window"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   47
      Top             =   0
      Width           =   4695
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Current Data in VB Arrays"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5040
      TabIndex        =   46
      Top             =   0
      Width           =   3135
   End
   Begin VB.OLE OLE1 
      Class           =   "Excel.Sheet"
      Height          =   7095
      Left            =   120
      SizeMode        =   1  'Stretch
      TabIndex        =   44
      TabStop         =   0   'False
      Top             =   240
      Width           =   4695
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      Caption         =   "Cycles in Wave"
      Height          =   255
      Left            =   8520
      TabIndex        =   43
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Status"
      Height          =   255
      Left            =   8460
      TabIndex        =   42
      Top             =   1920
      Width           =   3255
   End
   Begin VB.Label StatusLabel 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Stopped"
      Height          =   255
      Left            =   8460
      TabIndex        =   41
      Top             =   2160
      Width           =   3255
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Sampling Frequency (Hz)"
      Height          =   255
      Left            =   9960
      TabIndex        =   39
      Top             =   720
      Width           =   1935
   End
   Begin VB.Label Label3 
      Caption         =   "Number of Samples"
      Height          =   255
      Left            =   8520
      TabIndex        =   38
      Top             =   720
      Width           =   1455
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "Offset Voltage (V)"
      Height          =   255
      Left            =   10200
      TabIndex        =   37
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Amplitude (V)"
      Height          =   255
      Left            =   8520
      TabIndex        =   36
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Acquire"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit         'Helps catch typing errors.
'
'---------------------------------------------------
'Simple stimulus/response testing program for Keithley DAS-1800AO series.
'Form control and interfacing is contained here.
'Functions which talk to Excel are contained in ExcelInterface.bas
'Functions which calculate characteristics for a wave are contained in
'   WaveAnalysis.bas.  It also includes the user defined type Wave.
'DLVBLib.bas contains all the high level DriverLINX subroutines for using the hardware.
'Dlcodes.bas contains result code constants of functions called from this library.
'Drvlnxvb.bas contains frequently used constants when calling functions and whatnot,
'   improving code readability.

'---------------------------------------------------
'   HOW THIS PROGRAM WORKS
'       This program is designed to interface with a DAS 1800AO series card.
'   It will synchronously send a sine wave through an AO channel (as defined
'   in LogicalChannelOutput) and read the resulting waveform (presumably altered
'   by external devices) at that same instant from the AI channel defined in
'   LogicalChannelInput.
'
'   Please see stimresp.doc for an explanation of the form and how to begin.
'
'   Please see walkthru.doc for a more procedural discription of this program.
'
'   This file is divided into two parts:  Event code and Called subroutines.
'
'       Here is a listing of the subroutines and functions in this program (without
'   parameters):
'
'   ---------------EVENT CODE---------------
'
'   Form_Load():    This routine runs as the program starts.  It initializes
'                   everything and sets up the synchronized AI/AO service requests.
'
'   cmdStart_Click(): When user clicks on Start, the service requests are executed.
'
'   cmdStop_Click(): When user clicks on Stop, sends a service reqest to stop acquisition.
'
'   cmdExit_Click(): When user clicks on exit, first stops acquisition (if it is
'                    happening), then exits.
'
'   AmplitudeTextBox_LostFocus():  When user changes this value, this routine
'                                  changes the output wave's amplitude and
'                                  generates a new sine wave.
'
'   OffsetTextBox_LostFocus():     Similar to AmplitudeTextBox_LostFocus(), but for
'                                  the wave's offset.
'
'   CyclesTextBox_LostFocus():     Similar to AmplitudeTextBox_LostFocus(), but
'                                  for the number of Cycles to put in one waveform
'                                  being outputted.
'
'   NumberOfSamplesTextBox_LostFocus(): When user changes this value, this
'                                       routine reinitializes arrays and calls
'                                       (again) the necessary Service Requests.
'
'   SamplingFrequencyTextBox_LostFocus(): When the user changes this value, this
'                                         routine ensures it's valid and updates
'                                         the GUI to reflect this change.
'
'   cmdSaveIn_Click():  When user clicks here, updates the window appropriately.
'
'   cmdSaveOut_Click(): When user clicks here, updates the window appropriately.
'
'   cmdSaveBoth_Click():    This routine saves the current data (AO and AI) to a
'                           text file.
'
'   cmdSave_Click():    This routine calls the function which saves the current
'                       data in Excel format.
'
'   cmdUpdateExcelWindow(): This command will begin the process which automatically
'                           updates Excel.
'
'   cmdUpdateGridWindow():  Resets the MSFlexGrid to display current data.
'
'   chkContinuous_Click():  This routine enables a sub-checkbox when activated.
'
'   SR1_CriticalError():DriverLINX may call this routine during execution.
'                       This routine reports the error and exits.
'
'   SR1_DataLost():     DriverLINX may call this routine during execution.
'                       This routine reports the error and exits.
'
'   SR2_DataLost():     DriverLINX may call this routine during execution (unlikely).
'                       This routine reports the error and exits.
'
'   SR1_ServiceStart(): This routine is called when DriverLINX begins the acquisition.
'
'   SR1_BufferFilled(): This routine is called when the input buffer is filled with data.
'                       In this routine the buffer is transferred to an array.
'
'   SR1_ServiceDone(): This routine is called when DriverLINX finishes the acquisition.
'
'   --------------CALLED SUBROUTINES-------------
'
'   Initialize():   This routine calls makes several Service Requests which
'                   set up the DriverLINX driver and LDD.
'
'   InitDevice():   This routine extracts a valid device number from the user
'                   for the driver selected and initializes that device.
'
'   SetupInitialServiceRequests():  Exactly what it sounds like.  Depending on
'                                   whether user elects for one-shot or continuous,
'                                   will set up those SR's to match it.
'
'   CloseLink():        Destructs OLE window which links to Excel.
'
'   OpenLink():         Constructs OLE window which links to Excel.
'
'   WriteAIData():      This routine will take the WaveData() array and
'                       write it to a file in ASCII format (presumably the
'                       data is from the AI channel).
'
'   WriteAOData():      This routine will take the WaveData() array and
'                       write it to a file in ASCII format (presumably the
'                       data is from the AO channel).
'
'   WriteAIAOData():    This routine will either append more data to the
'                       streaming file, or open, output the current data,
'                       and close it.
'
'   UpdateWindow():     This routine simply updates the text boxes on the
'                       screen with current values.
'
'   InitGrid():         This routine re-writes the column headers, and writes
'                       column 1 (with sample number).
'
'   faIndex():          Converts convenient (row, column) cell notation
'                       to MSFlexGrid linear notation.
'
'---------------------------------------------------
'VARIABLE AND CONSTANT DECLARATIONS
'
'[Incidentally, if creating a program from scratch, you have to remember to
'create your SR(s) and LDD(s) on the form first.  This could be considered
'a declaration.]

Const NumberOfBuffers As Integer = 2    '2 should be enough for this application.
                                        'Numbering starts at 0, so with 2 buffers
                                        'we have buffer 0 and buffer 1.
Const ChannelGain As Double = -4#       '+ for unipolar, - for bipolar.  Acceptable values
                                        'differ depending on 1800 model: 1801AO has gains of
                                        '1,5,50,250 (all +/-).  1802AO has gains of 1,2,4,8.
                                        '(all +/-).  3108 has 1,2,4,8,10,20,40,80,100,200,
                                        '400,800.
Const LogicalChannelOutput As Integer = 0   'Output channel number.  Set this to
                                            '   what you're physically hooked up to.
Const LogicalChannelInput As Integer = 0    'Input channel number.  Set this to
                                            '   what you're physically hooked up to.
Const BackGroundForeGround As Integer = Background  '(Defined in DLVBLib.bas)
                                                    'We want hardware (DMA), so we
                                                    'choose background.
Dim DeviceNumber As Integer             'Specifies which logical device we're using.
                                        'This number was entered when you configured
                                        'DriverLINX with your 1800 series card.
Dim NumberOfSamples As Integer          'How many data values to read?
Dim SamplingFrequency As Double         '5 KHz is a good value to ensure accuracy.
Dim SamplingPeriod As Double            'Initialized to 1/SamplingFreq.
Dim InputWave As Wave                   'See DLVBLIB.bas for Wave type
Dim OutputWave As Wave
Dim OutputWaveData() As Single          '1D array containing voltages
Dim InputWaveData() As Single

'-------------------EVENT CODE---------------------
Private Sub Form_load()
    'DECLARATIONS
           
    'INITIALIZATIONS
    Call Initialize
    
    'PROCEDURE
        
    'STEP 3: Create a wave.
    'The values which CreateSineWave generates it puts in OutputWaveData()
    Call CreateSineWave(OutputWave, OutputWaveData(), NumberOfSamples)
    
    'STEP 4: Setup the service requests for continuous, synchronous AI and AO.
    
    Call SetupInitialServiceRequests
    
End Sub

Private Sub cmdStart_Click()
    
    'They clicked on start.
    'First, disable the start and enable the Stop buttons.
    cmdStart.Enabled = False
    cmdStop.Enabled = True
    
    'STEP 5: Fill the buffer for output on the AO channel.
    'The function is apprarently misnamed.  It seems like it should
    '   be PutDriverLINXAOBuffer (not AI), because the code in the function writes
    '   the data to the output buffer.
    'I believe that it is named like this to be consistant with GetDriverLINXAIBuffer().
    
    Call PutDriverLINXAIBuffer(SR2, 0, NumberOfSamples, OutputWaveData())
        'We don't really need the value this function returns, since the function
        '   itself will call the error handler if it needs to.
    Call PutDriverLINXAIBuffer(SR2, 1, NumberOfSamples, OutputWaveData())
        'Same for other buffer.
    
    'Now execute the service requests.  Remember, since these are hardware controlled
    'and not software driven, the DriverLINX software will inform US when a buffer is
    'ready by calling SR1_BufferFilled() (also will call SR1_ServiceStart and
    'SR1_ServiceDone when a task is begun and ended, respectively).
    
    SR2.Refresh 'Output
    SR1.Refresh 'Input
    
End Sub

Private Sub cmdStop_Click()
Dim Status As Integer
    
    ' This function is called when the stop button is clicked.
    ' Make sure that there are no active tasks
    Status = StopDriverLINXIO(SR1)
    StatusLabel.Caption = "DriverLINX returned " + Str(Status) + "."
    
    ' If active task is found, do not exit until DriverLINX notifies
    '   us via calling SR1_ServiceDone (remember this routine will enable the start button)
    If Status = DL_NoErr Then
     Do
            DoEvents
        Loop Until cmdStart.Enabled
    End If
    
    'Same procedure for SR2
    Status = StopDriverLINXIO(SR2)
    StatusLabel.Caption = "DriverLINX returned " + Str(Status) + "."
    ' If active task is found, do not exit until DriverLINX notifies
    '   you that it is really done.
    If Status = DL_NoErr Then
     Do
            DoEvents
     Loop Until cmdStart.Enabled
    End If
         
     'Disable the stop button until task is restarted
    cmdStop.Enabled = False
    AmplitudeTextBox.Enabled = True
    CyclesTextBox.Enabled = True
    OffsetTextBox.Enabled = True
    NumberOfSamplesTextBox.Enabled = True
    SamplingFrequencyTextBox.Enabled = True

End Sub
Private Sub cmdExit_Click()
    'They clicked on exit.
    'They effectively have to click on stop before they exit.  Since they
    '   didn't, we'll do it for them.
    
    cmdStop_Click
   
    'Close the open drivers.
    Call CloseDriverLINXDriver(SR2)
    Call CloseDriverLINXDriver(SR1)
    
    'Close any open file
    Close
    
    ' Quit this application
    End
End Sub
Private Sub AmplitudeTextBox_LostFocus()
    'Update OutputWave when Amplitude changes.
    OutputWave.Amplitude = Val(AmplitudeTextBox.Text)
    Call CreateSineWave(OutputWave, OutputWaveData(), NumberOfSamples)
    
End Sub
Private Sub OffsetTextBox_LostFocus()
    'Update OutputWave when Offset changes.
    OutputWave.Offset = Val(OffsetTextBox.Text)
    Call CreateSineWave(OutputWave, OutputWaveData(), NumberOfSamples)
    
End Sub

Private Sub CyclesTextBox_LostFocus()
    'Update OutputWave when Frequency changes.
    Select Case Val(CyclesTextBox.Text)
        Case Is <= 0
            CyclesTextBox.Text = 1
        Case Is >= (NumberOfSamples / 2)
            MsgBox "Warning: Aliasing will occur with this value!", vbOKOnly
    End Select
    
    OutputWave.Cycles = Val(CyclesTextBox.Text)
    OutputWave.Frequency = CDbl(SamplingFrequency) / (CDbl(NumberOfSamples) / OutputWave.Cycles)
    ActualFrequencyTextBox.Text = Str(OutputWave.Frequency)
    Call CreateSineWave(OutputWave, OutputWaveData(), NumberOfSamples)
    
End Sub

Private Sub NumberOfSamplesTextBox_LostFocus()
    'Update Wave Arrays and MsFlexGrid when NumberOfSamples changes.
    With NumberOfSamplesTextBox
        Select Case Val(.Text)
            Case Is > 32766     'Trap overflow
                .Text = 32766
            Case Is < 1
                .Text = 1
        End Select
        
        If Val(.Text) <= OutputWave.Cycles * 2 Then
            MsgBox "Warning: Aliasing will occur with this value!", vbOKOnly
        End If
        
        NumberOfSamples = Val(.Text)
        OutputWave.Frequency = CDbl(SamplingFrequency) / (CDbl(NumberOfSamples) / OutputWave.Cycles)
        ActualFrequencyTextBox.Text = OutputWave.Frequency
    End With
    
    ReDim InputWaveData(0 To NumberOfSamples - 1)
    ReDim OutputWaveData(0 To NumberOfSamples - 1)
    
    Call SetupInitialServiceRequests    'Have to re-setup our SR1 and SR2 if we change
    Call CreateSineWave(OutputWave, OutputWaveData(), NumberOfSamples)     'NumberOfSamples.
    Call InitGrid
    
End Sub

Private Sub SamplingFrequencyTextBox_LostFocus()
    'When someone changes SamplingFrequency, have to change SR1 and SR2.
    
    With SamplingFrequencyTextBox
        Select Case Val(.Text)
            Case Is > 333333    'DAS-1800AO rated max throughput.
                .Text = 333333
            Case Is < 1
                .Text = 1
        End Select
        
        SamplingFrequency = Val(.Text)  'Change variable to reflect text box.
        OutputWave.Frequency = CDbl(SamplingFrequency) / (CDbl(NumberOfSamples) / OutputWave.Cycles)
        ActualFrequencyTextBox.Text = OutputWave.Frequency
    End With
    Call SetupInitialServiceRequests
End Sub

Private Sub cmdSaveIn_Click()
    Call WriteAIData
End Sub

Private Sub cmdSaveOut_Click()
    Call WriteAOData
End Sub
Private Sub cmdSaveBoth_Click()
    Call WriteAIAOData(False)
End Sub
Private Sub cmdSave_Click()
    'This will run the routine (in ExcelInterface.bas) that saves the data to
    'an .xls file -- for users who don't want automation and will handle their
    'own data.

   Dim TempStatus As String
    
   TempStatus = StatusLabel.Caption
   cmdSave.Enabled = False
   
   StatusLabel.Caption = "Saving Data. . ."
   Call ExcelSave(InputWaveData(), OutputWaveData(), FileBoxSaveAsExcel.Text, NumberOfSamples)
   
   cmdSave.Enabled = True
   StatusLabel.Caption = TempStatus
   
End Sub

Private Sub cmdUpdateExcelWindow_Click()
    'Because the ExcelUpdate routine updates the worksheet so many times, it
    'would become burdensome on the OLE window to keep the link active while
    'it updates.  So it is closed initially, then opened afterwards.
    
    Call CloseLink
    cmdUpdateExcelWindow.Enabled = False
    
    'The only error we trap, because it is so important, is no Excel update
    'file.
    If Dir(FileBoxExcelLink.Text) = "" Then
        MsgBox "Please ensure that " + FileBoxExcelLink.Text + Chr(13) + "is present before attempting to update.", vbOKOnly
        Call cmdExit_Click
    End If
    
    Call ExcelUpdate(InputWaveData(), OutputWaveData(), OutputWave, _
                    Me, NumberOfSamples, SamplingFrequency, chkResetFreq.value, chkSaveFreq)
    
    cmdUpdateExcelWindow.Enabled = True
    Call OpenLink
    
End Sub

Private Sub cmdUpdateGridWindow_Click()
    Call UpdateWindow
End Sub
Private Sub chkContinuous_Click()
    'Since the user should only be able to output continuously to a text file
    'when the DAQ runs continuously, we have to set up the check boxes as such.
    
    Select Case chkContinuous.value
        Case 0
            chkSaveContinuous.Enabled = False
            chkSaveContinuous.value = 0
        Case 1
            chkSaveContinuous.Enabled = True
            chkSaveContinuous.value = 0
        Case 2
            'Execution should never reach this point.
            chkContinuous.value = 0
    End Select
    Call SetupInitialServiceRequests
End Sub

Private Sub SR1_CriticalError(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
    'This event should really never occur (usually indicates a hardware error),
    'but it never hurts to trap it to eliminate ambiguity.
    
    MsgBox "Critical Error!", vbOKOnly, "Error"
    
    Call CloseDriverLINXDriver(SR2)
    Call CloseDriverLINXDriver(SR1)
    
    Close
    
    Unload Me
End Sub

Private Sub SR1_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
    'This event is called by SR1 whenever it (DriverLINX) can't keep up with the
    'DAQ card.  It can occur if the user enters a high Sampling Frequency, especially
    'when combined with a low number of buffers (i.e., a high frequency output).
    
    cmdStop_Click
    MsgBox "Data lost!", vbOKOnly, "Error"
    cmdStart.Enabled = True
    
End Sub
Private Sub SR2_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
    'See comments for SR1_DataLost
    
    cmdStop_Click
    MsgBox "Data lost!", vbOKOnly, "Error"
    cmdStart.Enabled = True
    
End Sub
Private Sub SR1_ServiceStart(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
    'This event is called by SR1 whenever a Data Acquisition task begins.
    'When this happens, we need to disable several things on the GUI, so that the user
    'cannot interfere with the Data Acq process.
    
    ' Disable the start button while a task is running
    cmdStart.Enabled = False
    cmdStop.Enabled = True
    AmplitudeTextBox.Enabled = False
    CyclesTextBox.Enabled = False
    OffsetTextBox.Enabled = False
    NumberOfSamplesTextBox.Enabled = False
    SamplingFrequencyTextBox.Enabled = False
    chkSaveContinuous.Enabled = False
    chkContinuous.Enabled = False
    StatusLabel = "Running. . ."
    cmdStop.SetFocus
    
    If chkSaveContinuous.value Then
        Open FileBoxBoth.Text For Output As #1
    End If

End Sub
Private Sub SR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
    
    Dim samples As Long
            
    ' STEP 9: Process results
    '    Because buffered I/O tasks execute in the background, your
    '    application will not have any data to process until your
    '    DriverLINXSR control informs it that a buffer has filled.
    '    When you set the DriverLINXSR property, Sel_buf_notify, equal
    '    to DL_NOTIFY, the DriverLINXSR control calls this subroutine
    '    whenever it has filled a buffer with new data. At this point,
    '    you can transfer the data in this buffer from the DriverLINXSR
    '    control to an array defined in your application.
    
    samples = GetDriverLINXAIBuffer(SR1, bufIndex, InputWaveData())
    StatusLabel.Caption = "Reading buffer" & Str(bufIndex)
        
    'Now we update the data.
       
    If chkSaveContinuous.value Then
        SR1.Sel_buf_notify = DL_NOEVENTS
        Call WriteAIAOData(True)
        SR1.Sel_buf_notify = DL_NOTIFY
    End If
    
End Sub
Private Sub SR1_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The SR calls this subroutine when a task ends. This
    ' application uses this ServiceDone event to update the form,
    ' indicating that no task is running, as well as to repaint the data
    ' in the window if the user has elected to.
      
    ' Reenable the start button when a task ends.
    
    cmdStart.Enabled = True
    cmdStop.Enabled = False
    AmplitudeTextBox.Enabled = True
    CyclesTextBox.Enabled = True
    OffsetTextBox.Enabled = True
    NumberOfSamplesTextBox.Enabled = True
    SamplingFrequencyTextBox.Enabled = True
    chkContinuous.Enabled = True
    cmdStart.SetFocus
    
    If chkContinuous.value Then
        chkSaveContinuous.Enabled = True
    End If
    
    StatusLabel.Caption = "Stopped."
    
    Close                   'If user was streaming data, we stop now.
    
    If chkUpdateOnEnd.value Then
        Call UpdateWindow   'Update if check box is checked.
    End If
    If chkUpdateExcelOnEnd.value Then
        Call cmdUpdateExcelWindow_Click   'Update Excel at the same time.
    End If
    
End Sub

'----------------------CALLED SUBROUTINES--------------------
Private Sub Initialize()
    'VARIABLE DECLARATIONS
    Dim DriverName As String
    
    'FORM SETTINGS
    cmdStop.Enabled = False
    optOverwriteIn.value = True
    optOverwriteOut.value = True
    optOverwriteBoth.value = True
    
    'ChDir (app.path)
    FileBoxIn.Text = App.Path + "\ai.txt"
    FileBoxOut.Text = App.Path + "\ao.txt"
    FileBoxBoth.Text = App.Path + "\aiao.txt"
    FileBoxExcelLink.Text = App.Path + "\layout.xls"
    FileBoxSaveAsExcel.Text = App.Path + "\rawdata.xls"
        
    'VARIABLE INITIALIZATIONS
    DeviceNumber = 0
    NumberOfSamples = Val(NumberOfSamplesTextBox.Text)
    SamplingFrequency = Val(SamplingFrequencyTextBox.Text)
    SamplingPeriod = 1 / SamplingFrequency
    ReDim InputWaveData(0 To NumberOfSamples - 1)
    ReDim OutputWaveData(0 To NumberOfSamples - 1)
    OutputWave.Cycles = Val(CyclesTextBox.Text)
    OutputWave.Amplitude = Val(AmplitudeTextBox.Text)
    OutputWave.Offset = Val(OffsetTextBox.Text)
    OutputWave.Frequency = CDbl(SamplingFrequency) / (CDbl(NumberOfSamples) / OutputWave.Cycles)
    ActualFrequencyTextBox.Text = Str(OutputWave.Frequency)
        
    'MISC INITIALIZATIONS
    Call InitGrid           'Initialize MSFlexGrid1
    MSFlexGrid1.ColWidth(0) = 650
    MSFlexGrid1.ColWidth(1) = 1132
    MSFlexGrid1.ColWidth(2) = 1132
        
    'DRIVERLINX INITIALIZATION
        
    StatusLabel.Caption = "Initializing DriverLINX. . ."
    'STEP 1: Open DriverLINX Driver.  Arguments 2 and 3 tell the function to prompt
    '   the user for which driver to open.
    DriverName = OpenDriverLINXDriver(SR1, "", False)
    
    'Now we must check and make sure a driver was opened. (If not, quit).
    'Remember that OpenDriverLINXDriver will return "" (no string) if no
    '   driver was opened.
    
    If DriverName = "" Then
        MsgBox "No driver opened.", vbOKOnly, "Error Opening Driver"
        End
    End If
    
    'Since both service requests should refer to the same device, we must
    '   set SR2 as such (SR1 was updated when we called OpenDriverLINXDriver).
    
    SR2.Req_DLL_name = SR1.Req_DLL_name
    
    'STEP 2: Initialize the logical devices.
    'Again, if either are not initialized, then we quit.
    'DL_NoErr is defined in Dlcodes.bas.
    
    Call InitDevice(DriverName)
    
    StatusLabel.Caption = "Stopped."
    
    'Since we're dealing with an 1800 series card, we know it supports both
    'AO (Analog output) and AI (analog input).  So any check for the subsystem
    'is really redundant.
End Sub
Private Sub InitDevice(ByVal DriverName As String)
    'The code in the loop here basically just extracts a valid device number from
    'the user in case his device is not the default 0.  It will exit if the user
    'hits cancel.
    
    Dim ValidDevice As Boolean, LongDevice As Long
    Dim result1 As Integer, result2 As Integer, result3 As Integer
    
    ValidDevice = True      'Assume Device 0 is a valid number to start.
    
    Do
    
    If ValidDevice Then   'Try to (re)initialize
      result1 = InitializeDriverLINXDevice(SR1, DeviceNumber)
      result2 = InitializeDriverLINXDevice(SR2, DeviceNumber)
        
        If result1 <> DL_NoErr Or result2 <> DL_NoErr Then
            ValidDevice = False
        Else  'There was no error initializing.  Exit this loop. (The only way out)
            Exit Do
        End If
    
    Else    'ValidDevice=False
        If MsgBox("Error initializing " & DriverName & " (device " & DeviceNumber _
            & ")." & Chr(13) & "Do you want to select a different device?" _
            , vbYesNo, "Initialization Error") = vbYes Then
            'User selected Yes, so let him input a value.
            LongDevice = CLng(Val(InputBox("Please enter a logical device number:", _
            "New Device Number", 0)))
            
            'Insure value is ok
            Do
                Select Case LongDevice
                      Case Is < 0       'Trap for negative values.
                        MsgBox "Invalid Device Number.  Please enter an integer between 0 and" _
                        & " 32767.", vbOKOnly, "Error"
                    
                        LongDevice = CLng(Val(InputBox("Input Logical Device Number", _
                        "New Device Number", 0)))
                        
                        ValidDevice = False
                      Case Is > 32767   'Trap for overflow.
                        MsgBox "Invalid Device Number.  Please enter an integer between 0 and" _
                        & " 32767.", vbOKOnly, "Error"
                    
                        LongDevice = CLng(Val(InputBox("Input Logical Device Number", _
                        "New Device Number", 0)))
                        
                        ValidDevice = False
                      Case Else         'Must be a valid integer.  Try initializing.
                        ValidDevice = True
                        DeviceNumber = CInt(LongDevice)
                End Select
            Loop Until ValidDevice = True
        Else    'User selected No, so we quit.
            Call cmdExit_Click
        End If
        
    End If
    
    Loop
End Sub
Private Sub SetupInitialServiceRequests()
    If chkContinuous.value Then
        Call SetupDriverLINXContinuousBufferedIO(SR1, LDD, DeviceNumber, _
                                            DL_AI, LogicalChannelInput, _
                                            ChannelGain, SamplingFrequency, _
                                            NumberOfSamples, NumberOfBuffers, _
                                            BackGroundForeGround)
    
    'Setup the AO Service Request using the Default Analog
    'Input Clock (which is the same clock as SR1 is using [i.e., synchronous]).
        Call SetupDriverLINXContinuousSynchronizedBufferedIO(SR2, SR1, LDD, _
                                                        DeviceNumber, DL_AO, _
                                                        LogicalChannelOutput, _
                                                        ChannelGain, _
                                                        NumberOfSamples, _
                                                        NumberOfBuffers, _
                                                        BackGroundForeGround)
    Else    '(not continuous, just once)
        Call SetupDriverLINXBufferedIO(SR1, LDD, DeviceNumber, DL_AI, LogicalChannelInput, _
                                    ChannelGain, CSng(SamplingFrequency), NumberOfSamples, _
                                    NumberOfBuffers, BackGroundForeGround)
                                    
                                            
        Call SetupDriverLINXBufferedIO(SR2, LDD, DeviceNumber, DL_AO, LogicalChannelOutput, _
                                    ChannelGain, CSng(SamplingFrequency), NumberOfSamples, _
                                    NumberOfBuffers, BackGroundForeGround)
        
        'But remember, the second SR here doesn't synchronize it (there's no function
        'in the driverlinx library to do it directly), so we have to add it ourselves.
        AddTimingEventSyncIO SR2, GetSubSystemsDefaultClock(SR1, LDD, SR1.Req_subsystem)
        
        'This command adds the same clock to SR2 as SR1 has (the second argument returns
        'the clock that SR1 is using)
    End If
    
    'Our Service Requests are all set up.
    'Now all we need to do is fill the buffers and execute the service requests.
    'This happens when cmdStart_Click() executes
    '(i.e., the Start button is clicked).
End Sub
Public Sub CloseLink()
    'Destruct the OLE window which contains the link to the Excel Workaheet.
    OLE1.Delete
End Sub
Public Sub OpenLink()
    'Construct the OLE window which conains the link to the Excel Worksheet.
    OLE1.CreateLink (FileBoxExcelLink.Text)
End Sub
Private Sub WriteAIData()
    'This routine will either overwrite or append the current data in
    'InputWaveData to a file given by FileBoxIn.text
        
    Dim i As Integer
    Dim TempStatus As String
    TempStatus = StatusLabel.Caption
     
    If optOverwriteIn.value Then
        Open FileBoxIn.Text For Output As #1
        StatusLabel.Caption = "Writing to " & FileBoxIn.Text
        For i = 0 To NumberOfSamples - 1
            Write #1, InputWaveData(i)
        Next i
        Close #1
          
    Else
        Open FileBoxIn.Text For Append As #1
        StatusLabel.Caption = "Appending to " & FileBoxIn.Text
        For i = 0 To NumberOfSamples - 1
            Write #1, InputWaveData(i)
        Next i
                   
        Close #1
    End If
    
    StatusLabel.Caption = TempStatus

End Sub
Private Sub WriteAOData()
    'This routine will either overwrite or append the current data in
    'InputWaveData to a file given by FileBoxIn.text
        
    Dim i As Integer
    Dim TempStatus As String
       
    TempStatus = StatusLabel.Caption
        
    If optOverwriteOut.value Then
        Open FileBoxOut.Text For Output As #1
        StatusLabel.Caption = "Writing to " & FileBoxOut.Text
        For i = 0 To NumberOfSamples - 1
            Write #1, OutputWaveData(i)
        Next i
        Close #1
    Else
        Open FileBoxOut.Text For Append As #1
        StatusLabel.Caption = "Writing to " & FileBoxOut.Text
        For i = 0 To NumberOfSamples - 1
            Write #1, OutputWaveData(i)
        Next i
        Close #1
    End If
        
    StatusLabel.Caption = TempStatus

End Sub
Private Sub WriteAIAOData(ByVal Running As Boolean)
    'This routine will either open and output its data to a file as given by
    'FileBoxBoth.text, or will append its data (presumably streamed from the
    'DAQ card) to a file.
    
    'N.B.: One way to speed up streaming, for those interested, is to not output
    'ASCII data like output does.  Instead, one could open a file as Binary, then
    'put and get the data (which would be stored, if single, as 4 bytes instead
    'of the 8-10 or so bytes to store it as ASCII).
    
    Dim i As Integer
    Dim TempStatus As String
       
    TempStatus = StatusLabel.Caption
    
    StatusLabel.Caption = "Writing to " & FileBoxBoth.Text
    
    Select Case chkSaveContinuous.value
     Case 0 'We are NOT streaming data.
        Select Case optOverwriteBoth.value
            Case True   'Overwrite
                Open FileBoxBoth.Text For Output As #2
                For i = 0 To NumberOfSamples - 1
                    Write #2, OutputWaveData(i); InputWaveData(i)
                Next i
                Close #2
            Case False  'Append
                Open FileBoxBoth.Text For Append As #2
                For i = 0 To NumberOfSamples - 1
                    Write #2, OutputWaveData(i); InputWaveData(i)
                Next i
                Close #2
        End Select
        
     Case 1 'We are streaming data.
        If Running = True Then  'Only save continuous data if we are really acquiring.
            For i = 0 To NumberOfSamples - 1
                Write #1, OutputWaveData(i); InputWaveData(i)
            Next i
        End If
     Case 2  'Grayed?!
        'Do nothing--should never happen anyway.
    End Select
    
    StatusLabel.Caption = TempStatus
End Sub

Private Sub UpdateWindow()
    'This routine simply refreshes the MSFLexGrid Window.
    
    Dim i As Integer
    Dim TempCaption As String
    
    TempCaption = StatusLabel.Caption
    StatusLabel.Caption = "Updating Window. . ."
    
    Call InitGrid   'This routine fills the "A" column with the sample number.
    
    'Fill "B" column.
    For i = 1 To NumberOfSamples
        MSFlexGrid1.TextArray(faIndex(i, 1)) = OutputWaveData(i - 1)
    Next i
    
    'Fill "C" column.
    For i = 1 To NumberOfSamples
        MSFlexGrid1.TextArray(faIndex(i, 2)) = InputWaveData(i - 1)
    Next i
    
    StatusLabel.Caption = TempCaption
    
End Sub

Private Sub InitGrid()
    'This routine re-writes the column headers, and writes column 1 (with
    'sample number).
    
    Dim i As Integer
    
    MSFlexGrid1.Rows = NumberOfSamples + 1
    MSFlexGrid1.TextArray(faIndex(0, 0)) = "Sample"
    MSFlexGrid1.TextArray(faIndex(0, 1)) = "AO Data"
    MSFlexGrid1.TextArray(faIndex(0, 2)) = "AI Data"
    
    For i = 1 To NumberOfSamples
        MSFlexGrid1.TextArray(faIndex(i, 0)) = i
    Next i
    
End Sub
Private Function faIndex(row As Integer, col As Integer) As Long
    'Quick conversion function (lifted from help file).
    faIndex = row * MSFlexGrid1.Cols + col
End Function
